INCLUDE ht66f2370.inc
INCLUDE "ui.inc"

;******************************************************************  
; RF Constant define
;******************************************************************  

;*********************************************************
;Choose the Leading Code mode
;*********************************************************
#define		leading_code	     4		;3 	1f high + 31f low		;* RF BIOS V1.00
								        ;4  (1f high+1f low)*23	;* KEELOQ  V1.00
;*********************************************************
;Choose Start Format
;*********************************************************
#define		start_format	     3      ;1	disable					;* RF BIOS V1.00
							 	        ;3  (0f high+10f low)		;* KEELOQ  V1.00
;******************************************************************
;CHOOSE  Bit Format
;******************************************************************                    		
#define 	Bit_Format 		     2      ;2	only
								        ;	0-data: 2f high+ 1f low 		;* KEELOQ V1.00 
                      			        ;	1-data: 1f high+ 2f low						 	
;******************************************************************
;Set the Encrypted Code Data and the Fixed Code Data width
;******************************************************************
#define		Encrypted_C			32	    ;32-bit Encrypted Code Data
#define		Fixed_C			    28	    ;28-bit Fixed Code Data

;******************************************************************
;CHOOSE  Button bit+VLow bit+Repeat bit(STATUS_Bit)
;******************************************************************				
#define 	STATUS_Bit			6	    ;6-bit

;Set the symbol rate 
;******************************************************************								
#define 	Symbol_rate		  RF_DM_SYMBOL_TIME		;100/125/188/210/228/250/275/305/335/368us

;******************************************************************
;Choose RF timer overflow flag
;******************************************************************
#define		RX_TMF			STM0AF

#define		RFDATA			PD0         ;modify0603


if(Symbol_rate > 99)					
#define TXN		5						;Sampling frequency
else					
#define TXN		3						;Sampling frequency        
endif

#define RF_RX_CNT  (Symbol_rate*2/TXN)  ;*0.5us	  sampling time

;------------------------------------------------------------------        
InitRxTM  	MACRO
            MOV		A,00h		    		;fSYS/4=2MHz
            MOV		STMC0,A        	;
            MOV		A,0C1h		    	;Timer/Counter, CCRA
            MOV		STMC1,A        	;
            			
			MOV		A,LOW RF_RX_CNT
			MOV		STMAL,A
			MOV		A,HIGH RF_RX_CNT
			MOV		STMAH,A	
				
			SET		MF0E					
         	SET		STMAE
ENDM 
 
;------------------------------------------------------------------        
RFTimerOn	MACRO
           	SET     STON		
ENDM            

;------------------------------------------------------------------        
RFTimerOff	MACRO
           	CLR     STON		
ENDM 
